//////////
//
//	File:		VR3DTexture.c
//
//	Contains:	Support for adding a QuickTime movie or a picture as a texture on a QD3D object.
//
//	Written by:	Tim Monroe
//				Parts modeled on BoxMoov code by Rick Evans and Robert Dierkes.
//
//	Copyright:	 1996 by Apple Computer, Inc., all rights reserved.
//
//	Change History (most recent first):
//
//	   <1>	 	12/16/96	rtm		first file
//	   
//////////

#pragma once

#include <ImageCompression.h>
#include <Movies.h>
#include <QDOffscreen.h>

#include <QD3D.h>
#include <QD3DGroup.h>
#include <QD3DStorage.h>

// constants

#define kVR_TextureMovieVolAngle	180.0	// volume angle for all texture-mapped movies


// data structures

typedef struct {
	TQ3StoragePixmap			fStoragePixmap;		// the QD3D pixmap
	GWorldPtr					fpGWorld;			// the offscreen buffer into which the movie or picture is drawn
	Movie						fMovie;				// the movie source for animated textures
	MediaHandler				fMediaHandler;		// the sound media handler for animated textures
} Texture, *TexturePtr, **TextureHdl;


// function prototypes

TextureHdl			VR3DTexture_New (char *thePathName, Boolean isTextureMovie);
Boolean				VR3DTexture_Delete (TextureHdl theTexture);
TQ3Status			VR3DTexture_AddToGroup (TextureHdl theTexture, TQ3GroupObject theGroup);
Boolean				VR3DTexture_NextFrame (TextureHdl pAnimTxtr);